/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.virtual;

import gnu.awt.virtual.VirtualToolkit;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import javax.swing.RepaintManager;

public abstract class VirtualComponentPeer
implements ComponentPeer {
    protected Component component;
    protected Toolkit toolkit;
    protected Point location = new Point();
    protected Dimension size = new Dimension();

    @Override
    public void dispose() {
    }

    public void setCursor(Cursor cursor) {
    }

    public VirtualComponentPeer(Toolkit toolkit, Component component) {
        this.toolkit = toolkit;
        this.component = component;
        this.setBounds(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        RepaintManager.currentManager(component).setDoubleBufferingEnabled(false);
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void paint(Graphics g) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void print(Graphics g) {
    }

    @Override
    public Graphics getGraphics() {
        Container parent = this.component.getParent();
        if (parent != null) {
            System.err.println("creating relative graphics");
            return parent.getGraphics().create(this.location.x, this.location.y, this.size.width, this.size.height);
        }
        throw new Error();
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        System.err.println("getGraphicsConfiguration");
        return null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.size.width = width;
        this.size.height = height;
    }

    @Override
    public Point getLocationOnScreen() {
        Point screen = new Point(this.location);
        Container parent = this.component.getParent();
        if (parent != null) {
            Point parentScreen = parent.getLocationOnScreen();
            screen.translate(parentScreen.x, parentScreen.y);
        }
        return screen;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setEnabled(boolean b) {
    }

    public void requestFocus() {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void handleEvent(AWTEvent e) {
        System.err.println(e);
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
        System.err.println(e);
    }

    @Override
    public ColorModel getColorModel() {
        return this.getToolkit().getColorModel();
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    @Override
    public void setFont(Font f) {
    }

    public Toolkit getToolkit() {
        if (this.toolkit == null) {
            this.toolkit = new VirtualToolkit();
        }
        return this.toolkit;
    }

    public Image createImage(ImageProducer producer) {
        System.err.println("createImage(producer)");
        return null;
    }

    @Override
    public Image createImage(int width, int height) {
        Container parent = this.component.getParent();
        if (parent != null) {
            return parent.createImage(width, height);
        }
        throw new Error();
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        System.err.println("prepareImage");
        return true;
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        System.err.println("checkImage");
        return 32;
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public void reparent(ContainerPeer newContainer) {
    }
}

